<?php

$u_lng = isset($user['lng']) ? $user['lng'] : ($settings['default_lang'] ?? 'fa');

if ($u_lng == 'en') {
    $lng_toman = "IRT";
    $lng_loading_title_banned = "Banned";
    $lng_loading_title_maintenance = "Maintenance";
    $lng_loading_title_join = "Required Join";
    $lng_loading_title_phone = "Phone Verification";
    $lng_loading_title_loading = "Loading...";

    // Banned Page
    $lng_loading_banned_h2 = "Account Banned";
    $lng_loading_banned_p = "Dear user, your access to the bot has been blocked by the administration.";

    // Maintenance Page
    $lng_loading_maint_h2 = "Under Maintenance";
    $lng_loading_maint_p = "The bot is temporarily disabled for maintenance and updates. Please check back later.";
    
    // Join Channel
    $lng_loading_join_channel_title = "Channel"; 
    $lng_loading_join_btn_done = "✅ I Joined";
    $lng_loading_join_message = "🚸 To use the bot, please join the following channels first.\n\n▪️After joining, click on the « I Joined » button.";
    
    // Join Page
    $lng_loading_join_page_h2 = "Membership Required";
    $lng_loading_join_page_p1 = "The list of channels has been sent to you in the bot.";
    $lng_loading_join_page_p2 = "Please return to the bot chat, join, and then try again.";
    
    // Phone Page
    $lng_loading_phone_h2 = "Verify Mobile Number";
    $lng_loading_phone_p1 = "Dear user, to verify your identity and enter the store, you must register your phone number.";
    $lng_loading_phone_p2 = "Please return to the bot and send the <b>\"/start\"</b> command.";
    
    // Loader
    $lng_loading_loader_buy = "Buy";
    $lng_loading_loader_word1 = "Premium";
    $lng_loading_loader_word2 = "Telegram Stars";
    $lng_loading_loader_word3 = "Telegram Gifts";
    $lng_loading_loader_word4 = "Virtual Numbers";
    // General
    $lng_api_invalid_input = "Submitted data is incomplete or invalid.";
    $lng_api_user_not_found = "User not found.";
    $lng_api_order_not_found = "Order not found.";
    $lng_api_order_not_found_or_pending = "Order not found or not processing.";
    $lng_api_invalid_action = "Invalid action.";
    $lng_api_err_unknown = "Unknown API error.";
    $lng_api_err_processing = "Processing error. Please try again or contact support.";
    $lng_api_err_panel_balance = "Order failed (Panel balance).";
    $lng_api_err_local_db = "Error saving order to local database.";
    $lng_api_order_success = "Your order has been submitted and is processing.";
    $lng_api_order_success_simple = "Order submitted successfully.";
    
    // Balance & Errors
    $lng_api_err_balance_irt = "Your IRT balance is not sufficient.";
    $lng_api_err_balance_ton = "Your TON balance is not sufficient.";
    $lng_api_err_balance_generic = "Your balance is not sufficient.";
    $lng_api_err_deduct_balance = "Error deducting user balance.";
    
    // Profile Updates
    $lng_api_name_updated = "Name updated.";
    $lng_api_name_failed = "Failed to update name.";
    $lng_api_name_invalid = "The entered name is not valid.";
    $lng_api_theme_updated = "Theme updated.";
    $lng_api_theme_failed = "Failed to update theme.";
    $lng_api_theme_invalid = "Invalid theme.";
    $lng_api_lang_updated = "Language updated.";
    $lng_api_lang_failed = "Failed to update language.";
    $lng_api_lang_invalid = "Invalid language.";
    
    // Premium
    $lng_api_err_premium_load = "Error loading premium plans list from database.";
    $lng_api_premium_plan_not_found = "The selected premium plan was not found or is inactive.";
    
    // Gift
    $lng_api_gift_invalid_id = "Gift ID or payment method is invalid.";
    $lng_api_gift_not_found = "Gift not found.";
    $lng_api_gift_out_of_stock = "Gift is out of stock.";
    $lng_api_gift_update_stock_err = "Error updating gift stock.";
    $lng_api_gift_order_err = "Error submitting gift order.";
    
    // Stars
    $lng_api_star_price_not_found = "Custom stars price not found.";
    $lng_api_star_service_not_found = "Custom stars service not found or is inactive.";
    
    // Virtual Number
    $lng_api_vnum_invalid_req_id = "Invalid request ID.";
    $lng_api_vnum_logout_success = "Logout request sent successfully.";
    $lng_api_vnum_logout_failed = "Error sending request. Please try again.";
    $lng_api_vnum_no_country = "Country or payment method not selected.";
    $lng_api_vnum_out_of_stock = "This country is out of stock or the price is invalid.";
    $lng_api_vnum_err_panel_balance = "Error: Service panel balance is low. Please notify support.";
    $lng_api_vnum_err_no_number = "Sorry, no number was found for this country (out of stock).";
    $lng_api_vnum_err_invalid_resp = "Invalid response received from API (Code: 200).";
    $lng_api_vnum_err_db_insert = "Error saving virtual number order to database.";
    $lng_api_vnum_success = "Number received successfully.";
    $lng_api_vnum_order_cancelled = "This order has been cancelled or has failed.";
    $lng_api_vnum_waiting_code = "Waiting for code...";
    $lng_api_vnum_cancel_err_completed = "Order is already completed and cannot be cancelled.";
    $lng_api_vnum_cancel_err_already = "Order was already cancelled.";
    $lng_api_vnum_cancel_err_status = "Error changing order status.";
    $lng_api_vnum_cancel_success_irt = "Order cancelled and %s IRT was refunded to your account.";
    $lng_api_vnum_cancel_success_ton = "Order cancelled and %s TON was refunded to your account.";
    $lng_api_vnum_cancel_err_refund = "Error refunding user.";
    $lng_api_vnum_cancel_err_processing = "Error during cancellation. Please try again.";
    $lng_api_vnum_cancel_err_invalid_state = "Order status is invalid for cancellation.";
    
    // IRT Charge
    $lng_api_irt_invalid_amount = "Invalid amount entered.";
    $lng_api_irt_min_err = "Amount is below the limit.\nMinimum deposit: ";
    $lng_api_irt_max_err = "Amount is above the limit.\nMaximum deposit: ";
    $lng_api_irt_valid_amount = "Valid amount";
    
    // TON Charge
    $lng_api_ton_invalid_amount = "Invalid amount.";
    $lng_api_ton_create_failed = "Failed to create payment record.";
    $lng_api_ton_invalid_order_code = "Invalid order code.";
    $lng_api_ton_already_verified = "Payment was already verified.";
    $lng_api_ton_invoice_expired = "Invoice has expired.";
    $lng_api_ton_verify_success = "Payment verified and balance updated.";
    $lng_api_ton_verify_pending = "Payment not yet confirmed. Please ensure you have completed the payment and try again in a moment.";
    
    $lng_bot_off = "⭕️ Bot is currently off.";
    $lng_user_banned = "📛 You are banned from this bot.";
    
    // قفل کانال
    $lng_join_btn = "✅ I Joined";
    $lng_join_msg = "🚸 To use the bot, please join the following channels first.\n\n▪️After joining, click on the « I Joined » button.";
    $lng_join_alert = "You have not joined all channels yet!";

    // تایید شماره
    $lng_phone_not_yours = "❌ Please send your own contact number.";
    $lng_phone_iran_only = "❌ Only Iranian numbers are allowed.";
    $lng_phone_verified = "✅ Your number has been verified.";
    $lng_phone_req_msg = "⚠️ Dear user, to verify your identity and use the bot, please confirm your phone number.\n\nClick the <b>«📱 Confirm Phone Number»</b> button below 👇";
    $lng_phone_req_btn = "📱 Confirm Phone Number";

    // استارت
    $lng_start_def = "<b>🔥 Welcome </b>\n\n🔻 Click the button below to enter the store";
    $lng_store_btn = "🛍 Open Store";

    // پرداخت کارت به کارت (سمت کاربر)
    $lng_card_send_receipt = "Please send the screenshot / payment receipt:";
    $lng_cancel_op = "❌ Cancel Operation";
    $lng_card_receipt_sent = "✅ Your receipt has been sent to support.\nYour account will be charged after review.";
    $lng_op_cancelled = "Operation cancelled.";
    $lng_card_rejected_user = "❌ Your card payment request was rejected by support.";
    
    // گزارش
    $lng_report_exists = "⚠️ You already have a pending report for this order. Please wait for the admin's response.";
    $lng_report_ask_text = "Please send your issue or comment regarding order (<code>%s</code>):";
    $lng_report_cancel = "❌ Cancel Report";
    $lng_report_sent = "✅ Your report has been sent to support.";
    $lng_admin_reply_prefix = "💬 <b>Support Reply to your Report:</b>\n\n";
    $lng_loading_not_started_h2 = "Registration Required";
    $lng_loading_not_started_p = "Dear user, your information was not found.\nPlease <b>Start</b> the bot first.";
    $lng_loading_btn_return = "Return to Bot";
    $lng_loading_btn_close = "Close";
} else {
    $lng_toman = "تومان";
    $lng_loading_title_banned = "مسدود شده";
    $lng_loading_title_maintenance = "بروزرسانی";
    $lng_loading_title_join = "عضویت اجباری";
    $lng_loading_title_phone = "تایید شماره";
    $lng_loading_title_loading = "در حال بارگذاری...";

    // Banned Page
    $lng_loading_banned_h2 = "حساب مسدود شده";
    $lng_loading_banned_p = "کاربر گرامی، دسترسی شما به ربات توسط مدیریت مسدود شده است.";

    // Maintenance Page
    $lng_loading_maint_h2 = "در حال بروزرسانی";
    $lng_loading_maint_p = "ربات موقتاً جهت انجام عملیات نگهداری و بروزرسانی غیرفعال می باشد. لطفا ساعاتی دیگر مراجعه کنید.";
    
    // Join Channel
    $lng_loading_join_channel_title = "کانال"; // for getChannelTitle default
    $lng_loading_join_btn_done = "✅ عضو شدم";
    $lng_loading_join_message = "🚸 برای استفاده از ربات، ابتدا در کانال های زیر عضو شوید.\n\n▪️بعد از عضویت روی دکمه « عضو شدم » بزنید.";
    
    // Join Page
    $lng_loading_join_page_h2 = "عضویت الزامی";
    $lng_loading_join_page_p1 = "لیست کانال ها برای شما در ربات ارسال شد.";
    $lng_loading_join_page_p2 = "لطفا به صفحه چت ربات برگردید و پس از عضویت، مجدد تلاش کنید.";
    
    // Phone Page
    $lng_loading_phone_h2 = "تایید شماره موبایل";
    $lng_loading_phone_p1 = "کاربر گرامی، برای احراز هویت و ورود به فروشگاه باید شماره تلفن خود را ثبت کنید.";
    $lng_loading_phone_p2 = "لطفا به ربات برگردید و دستور <b>\"/start\"</b> را بزنید.";
    
    // Loader
    $lng_loading_loader_buy = "خرید";
    $lng_loading_loader_word1 = "اشتراک پریمیوم";
    $lng_loading_loader_word2 = "استارز تلگرام";
    $lng_loading_loader_word3 = "گیفت تلگرام";
    $lng_loading_loader_word4 = "شماره مجازی";
    // General
    $lng_api_invalid_input = "اطلاعات ارسالی ناقص یا نامعتبر است.";
    $lng_api_user_not_found = "کاربر یافت نشد.";
    $lng_api_order_not_found = "سفارش یافت نشد.";
    $lng_api_order_not_found_or_pending = "سفارش یافت نشد یا در حال پردازش نیست.";
    $lng_api_invalid_action = "عملیات نامعتبر است.";
    $lng_api_err_unknown = "خطای ناشناخته از API.";
    $lng_api_err_processing = "خطا در پردازش. لطفا مجدد امتحان کنید یا به پشتیبانی اطلاع دهید.";
    $lng_api_err_panel_balance = "خطا در ثبت سفارش (موجودی پنل).";
    $lng_api_err_local_db = "خطا در ثبت سفارش در دیتابیس محلی.";
    $lng_api_order_success = "سفارش شما ثبت شد و در حال پردازش است.";
    $lng_api_order_success_simple = "سفارش با موفقیت ثبت شد.";
    
    // Balance & Errors
    $lng_api_err_balance_irt = "موجودی تومانی شما کافی نیست.";
    $lng_api_err_balance_ton = "موجودی TON شما کافی نیست.";
    $lng_api_err_balance_generic = "موجودی شما کافی نیست.";
    $lng_api_err_deduct_balance = "خطا در کسر موجودی کاربر.";
    
    // Profile Updates
    $lng_api_name_updated = "نام به روزرسانی شد.";
    $lng_api_name_failed = "خطا در به روزرسانی نام.";
    $lng_api_name_invalid = "نام وارد شده معتبر نیست.";
    $lng_api_theme_updated = "پوسته به روزرسانی شد.";
    $lng_api_theme_failed = "خطا در به روزرسانی پوسته.";
    $lng_api_theme_invalid = "پوسته نامعتبر است.";
    $lng_api_lang_updated = "زبان به روزرسانی شد.";
    $lng_api_lang_failed = "خطا در به روزرسانی زبان.";
    $lng_api_lang_invalid = "زبان نامعتبر است.";
    
    // Premium
    $lng_api_err_premium_load = "خطا در دریافت لیست پلن های پریمیوم از دیتابیس.";
    $lng_api_premium_plan_not_found = "پلن پریمیوم انتخاب شده یافت نشد یا غیرفعال است.";
    
    // Gift
    $lng_api_gift_invalid_id = "Gift ID یا متد پرداخت نامعتبر است.";
    $lng_api_gift_not_found = "گیفت یافت نشد.";
    $lng_api_gift_out_of_stock = "موجودی گیفت تمام شده است.";
    $lng_api_gift_update_stock_err = "خطا در به روزرسانی موجودی گیفت.";
    $lng_api_gift_order_err = "خطا در ثبت سفارش گیفت.";
    
    // Stars
    $lng_api_star_price_not_found = "قیمت استارز دلخواه یافت نشد.";
    $lng_api_star_service_not_found = "سرویس استارز دلخواه یافت نشد یا غیرفعال است.";
    
    // Virtual Number
    $lng_api_vnum_invalid_req_id = "ID درخواست نامعتبر است.";
    $lng_api_vnum_logout_success = "درخواست خروج از حساب با موفقیت ارسال شد.";
    $lng_api_vnum_logout_failed = "خطا در ارسال درخواست. لطفا مجدد تلاش کنید.";
    $lng_api_vnum_no_country = "کشور یا متد پرداخت انتخاب نشده است.";
    $lng_api_vnum_out_of_stock = "موجودی این کشور تمام شده یا قیمت نامعتبر است.";
    $lng_api_vnum_err_panel_balance = "خطا: موجودی پنل خدمات کافی نیست. لطفا به پشتیبانی اطلاع دهید.";
    $lng_api_vnum_err_no_number = "متاسفانه شماره ای برای این کشور یافت نشد (اتمام موجودی).";
    $lng_api_vnum_err_invalid_resp = "پاسخ دریافتی از API معتبر نبود (کد: 200).";
    $lng_api_vnum_err_db_insert = "خطا در ثبت سفارش شماره مجازی در دیتابیس.";
    $lng_api_vnum_success = "شماره با موفقیت دریافت شد.";
    $lng_api_vnum_order_cancelled = "این سفارش لغو شده یا با خطا مواجه شده است.";
    $lng_api_vnum_waiting_code = "در انتظار دریافت کد...";
    $lng_api_vnum_cancel_err_completed = "سفارش قبلا تکمیل شده و قابل لغو نیست.";
    $lng_api_vnum_cancel_err_already = "سفارش قبلا لغو شده بود.";
    $lng_api_vnum_cancel_err_status = "خطا در تغییر وضعیت سفارش.";
    $lng_api_vnum_cancel_success_irt = "سفارش لغو شد و مبلغ %s تومان به حساب شما بازگشت.";
    $lng_api_vnum_cancel_success_ton = "سفارش لغو شد و مبلغ %s تون به حساب شما بازگشت.";
    $lng_api_vnum_cancel_err_refund = "خطا در بازگشت وجه به کاربر.";
    $lng_api_vnum_cancel_err_processing = "خطا در فرآیند لغو. لطفا مجدد تلاش کنید.";
    $lng_api_vnum_cancel_err_invalid_state = "وضعیت سفارش برای لغو نامعتبر است.";
    
    // IRT Charge
    $lng_api_irt_invalid_amount = "مبلغ وارد شده نامعتبر است.";
    $lng_api_irt_min_err = "مبلغ کمتر از حد مجاز است.\nحداقل واریز: ";
    $lng_api_irt_max_err = "مبلغ بیشتر از حد مجاز است.\nحداکثر واریز: ";
    $lng_api_irt_valid_amount = "مبلغ معتبر است";
    
    // TON Charge
    $lng_api_ton_invalid_amount = "مبلغ نامعتبر است.";
    $lng_api_ton_create_failed = "خطا در ایجاد رکورد پرداخت.";
    $lng_api_ton_invalid_order_code = "کد سفارش نامعتبر است.";
    $lng_api_ton_already_verified = "پرداخت قبلا تایید شده بود.";
    $lng_api_ton_invoice_expired = "فاکتور منقضی شده است.";
    $lng_api_ton_verify_success = "پرداخت تایید شد و حساب شما شارژ شد.";
    $lng_api_ton_verify_pending = "پرداخت هنوز تایید نشده است. لطفا مطمئن شوید که پرداخت را کامل کرده اید و چند لحظه دیگر دوباره امتحان کنید.";
    
    $lng_bot_off = "⭕️ ربات فعلا خاموش میباشد .";
    $lng_user_banned = "📛 شما از ربات مسدود هستید .";

    // قفل کانال
    $lng_join_btn = "✅ عضو شدم";
    $lng_join_msg = "🚸 برای استفاده از ربات ، ابتدا در کانال های زیر عضو شوید.\n\n▪️بعد از عضویت روی دکمه « عضو شدم » بزنید.";
    $lng_join_alert = "هنوز در تمام کانال ها عضو نشده اید!";

    // تایید شماره
    $lng_phone_not_yours = "❌ لطفا شماره خودتان را ارسال کنید.";
    $lng_phone_iran_only = "❌ فقط شماره های ایران مجاز هستند.";
    $lng_phone_verified = "✅ شماره شما تایید شد.";
    $lng_phone_req_msg = "⚠️ کاربر گرامی، جهت احراز هویت و استفاده از ربات، لطفا شماره تماس خود را تایید کنید.\n\nروی دکمه <b>«📱 تایید شماره تلفن»</b> در پایین صفحه بزنید 👇";
    $lng_phone_req_btn = "📱 تایید شماره تلفن";

    // استارت
    $lng_start_def = "<b>🔥 خوش آمدید </b>\n\n🔻 برای ورود به فروشگاه خدمات روی دکمه زیر کلیک کنید";
    $lng_store_btn = "🛍️ ورود به فروشگاه";

    // پرداخت کارت به کارت (سمت کاربر)
    $lng_card_send_receipt = "لطفا اسکرین شات / رسید پرداخت خود را ارسال کنید:";
    $lng_cancel_op = "❌ لغو عملیات";
    $lng_card_receipt_sent = "✅ رسید شما برای پشتیبانی ارسال شد.\nپس از بررسی، حساب شما شارژ خواهد شد.";
    $lng_op_cancelled = "عملیات لغو شد.";
    $lng_card_rejected_user = "❌ درخواست شارژ حساب شما (کارت به کارت) توسط پشتیبانی رد شد.";

    // گزارش
    $lng_report_exists = "⚠️ شما قبلاً یک گزارش در انتظار پاسخ برای این سفارش ثبت کرده اید. لطفا تا دریافت پاسخ از سوی ادمین شکیبا باشید.";
    $lng_report_ask_text = "لطفا مشکل یا نظر خود را در مورد سفارش (<code>%s</code>) ارسال کنید:";
    $lng_report_cancel = "❌ لغو گزارش";
    $lng_report_sent = "✅ گزارش شما برای پشتیبانی ارسال شد.";
    $lng_admin_reply_prefix = "💬 <b>پاسخ پشتیبانی به گزارش شما:</b>\n\n";
}

// تکمیل سفارش دستی
$lng_ord_comp_en = "✅ Your %s order was completed successfully.\n\nThank you for your purchase.";
$lng_ord_comp_fa = "✅ سفارش %s شما با موفقیت انجام شد.\n\nاز خرید شما سپاسگزاریم.";

// لغو سفارش دستی
$lng_ord_cancel_en = "❌ Your %s order was cancelled by support.\n\n💰 Refunded: %s";
$lng_ord_cancel_fa = "❌ سفارش %s شما توسط پشتیبانی لغو شد.\n\n💰 مبلغ %s به کیف پول شما بازگشت.";

// شارژ حساب دستی (توسط ادمین)
$lng_bal_charge_en = "✅ Your account has been charged by support.\n💰 Amount: %s IRT";
$lng_bal_charge_fa = "✅ حساب شما به مبلغ %s تومان توسط پشتیبانی شارژ شد.";

// تکمیل گیفت
$lng_gift_comp_en = "✅ Your Gift order (<b>%s</b>) has been completed by support.\n\nThank you for your purchase!";
$lng_gift_comp_fa = "✅ سفارش گیفت شما (<b>%s</b>) توسط پشتیبانی تکمیل شد.\n\nاز خرید شما متشکریم!";

// لغو گیفت
$lng_gift_cancel_en = "❌ Your Gift order (<b>%s</b>) was cancelled by support.\n\n💰 Refunded: <b>%s</b>";
$lng_gift_cancel_fa = "❌ سفارش گیفت شما (<b>%s</b>) توسط پشتیبانی لغو شد.\n\nمبلغ <b>%s</b> به حساب شما بازگردانده شد.";

    $lng_loading_not_started_h2 = "ثبت نام الزامی است";
    $lng_loading_not_started_p = "کاربر گرامی، اطلاعات شما در سیستم یافت نشد.<br>لطفا ابتدا ربات را <b>استارت</b> کنید.";
    $lng_loading_btn_return = "بازگشت به ربات";
    $lng_loading_btn_close = "بستن";
?>